/*
 *
 * MyBigFont
 *
 * created manually with help from an example file created with FontCreator
 *  and a little help from MS Excel
 * This is a special character set created to utilise the full 16 pixel height
 *  of the Freetronics DMD displays
 *  (see http://www.freetronics.com/products/dot-matrix-display-32x16-red
 *  or http://www.jaycar.com.au/productView.asp?ID=XC4250
 * Only characters 32 (space) to 95 (underscore) are defined - no lower case.
 * The full-stop is replaced with a vertically centered decimal point to look
 *  better in the numerical display.
 * Also the space width is defined in this set. This is not usually the case.
 * Space is only 3 pixels wide.
 * See comments throughout for construction of file and the characters

 *
 * File Name           : MyBigFont.h
 * Date                : 12 Oct 2013
 * Font size in bytes  : 1663
 * Font width          : 14
 * Font height         : 16
 * Font first char     : 32
 * Font last char      : 95
 * Font used chars     : 64
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size in Bytes over all included Size it self - BUT IT IS NOT USED IN THE ARDUINO DMD LIBRARY
 *                                      except in the case of 0x00 0x00 which signifies a fixed width character set
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing - only used for fixed width font where no character width table is allowed
 *     uint8_t    font_Height_in_Pixel_for_all_characters - only used for fixed width fonts
 *                                      but is usually set to 'en' width for proportional spaced fonts
 *     unit8_t    font_First_Char
 *     uint8_t    font_Char_Count
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1]
 *                     1 entry per character indicating its width in pixels,
 *                     characters < 128 have an implicit virtual right empty row for character spacing
 *                      (This is built into the DMD library)
 *     uint8_t    font_data[];
 *                     bit field of all characters
 *                     The number of bytes must equal the entry in the width table
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef MYBIGFONT_H
#define MYBIGFONT_H

#define MYBIGFONT_WIDTH 10
#define MYBIGFONT_HEIGHT 16

static uint8_t MyBigFont[] PROGMEM = { // the name here 'MyBigFont' must be used to refer to this font
    0x04, 0x90, // size     the total size of the font in bytes   = 1168 bytes
    0x0A, // width          not actually used in this case but is set to en width (width of 'n' character)
          //                but being non-zero indicates that it is a variable width font and
          //                and the character width table is present.
    0x10, // height         max height of the characters = 16
    0x20, // first char     hex value of the first character (space)
    0x40, // char count     the number of characters in this font

    // char widths
    0x03, 0x03, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x03, 0x06, 0x06,    // 32 to 41
    0x08, 0x09, 0x05, 0x06, 0x04, 0x07, 0x0A, 0x07, 0x0A, 0x0A,    // 42 to 51
    0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x03, 0x05, 0x08, 0x06,    // 52 to 61
    0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,    // 62 to 71
    0x0A, 0x05, 0x0A, 0x0A, 0x0A, 0x0B, 0x0A, 0x0A, 0x0A, 0x0A,    // 72 to 81
    0x0A, 0x0A, 0x09, 0x0A, 0x0A, 0x0D, 0x0B, 0x0B, 0x0A, 0x05,    // 82 to 91
    0x07, 0x05, 0x09, 0x0A,                                        // 92 to 95

    // font data
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 32 space (only 3 pixels wide which is less than normal)
    0xFF, 0xFF, 0xFF, 0xCF, 0xCF, 0xCF, // 33 !
    0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 34 "
    0x70, 0x7E, 0xFE, 0xFE, 0x70, 0x70, 0xFE, 0xFE, 0xFE, 0x70, 0x0E, 0x7F, 0x7F, 0x7F, 0x0E, 0x0E, 0x7F, 0x7F, 0x7F, 0x0E, // 35 #
    0xF8, 0xFC, 0xFE, 0x8E, 0xFF, 0xFF, 0x8E, 0x8C, 0x8C, 0x18, 0x18, 0x31, 0x73, 0x73, 0xFF, 0xFF, 0x73, 0x73, 0x3F, 0x1F, // 36 $
    0x1E, 0x3F, 0x33, 0x3F, 0x9E, 0xE0, 0x78, 0x1E, 0x07, 0x03, 0xC0, 0xE0, 0x78, 0x1E, 0x07, 0x79, 0xFC, 0xCC, 0xFC, 0x78, // 37 %
    0x3E, 0x7F, 0xC3, 0xCF, 0x7E, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xFF, 0xC1, 0xC1, 0xFF, 0x7E, 0x18, 0x3C, 0x66, 0x42, // 38 &
    0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, // 39 '
    0xF0, 0xF8, 0x1C, 0x06, 0x03, 0x01, 0x0F, 0x1F, 0x38, 0x60, 0xC0, 0x80, // 40 (
    0x01, 0x03, 0x06, 0x1C, 0xF8, 0xF0, 0x80, 0xC0, 0x60, 0x38, 0x1F, 0x0F, // 41 )
    0xC3, 0x66, 0x3C, 0xFF, 0xFF, 0x3C, 0x66, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 42 *
    0x80, 0x80, 0x80, 0xF0, 0xF0, 0xF0, 0x80, 0x80, 0x80, 0x03, 0x03, 0x03, 0x1F, 0x1F, 0x1F, 0x03, 0x03, 0x03, // 43 +
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x78, 0x38, 0x38, // 44 ,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, // 45 -
    0x80, 0xC0, 0xC0, 0x80, 0x01, 0x03, 0x03, 0x01, // 46 . (NOTE that this is centered vertically for use as decimal point)
    0x00, 0x00, 0xC0, 0xF8, 0xFF, 0x1F, 0x03, 0xC0, 0xF8, 0xFF, 0x1F, 0x03, 0x00, 0x00, // 47 /
    0xFC, 0xFE, 0xFF, 0x07, 0x07, 0x07, 0x07, 0xFF, 0xFE, 0xFC, 0x3F, 0x7F, 0xFF, 0xE0, 0xE0, 0xE0, 0xE0, 0xFF, 0x7F, 0x3F, // 48 0
    0x0C, 0x0E, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0, // 49 1
    0x0C, 0x0E, 0x0F, 0x87, 0x87, 0x87, 0xCF, 0xFF, 0xFE, 0xFC, 0xFC, 0xFE, 0xFF, 0xE7, 0xE3, 0xE3, 0xE3, 0xE3, 0xE1, 0xE0, // 50 2
    0x0C, 0x0E, 0x8F, 0x87, 0x87, 0x87, 0x8F, 0xFF, 0xFE, 0xFC, 0x30, 0x70, 0xF3, 0xE3, 0xE3, 0xE3, 0xF3, 0xFF, 0x7F, 0x3F, // 51 3
    0x80, 0xC0, 0xF0, 0x78, 0x3E, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x1C, 0x1C, 0xFF, 0xFF, 0xFF, 0x1C, 0x1C, // 52 4
    0xFF, 0xFF, 0xFF, 0xC7, 0xC7, 0xC7, 0xC7, 0xC7, 0x87, 0x07, 0x30, 0x71, 0xF1, 0xE1, 0xE1, 0xE1, 0xF3, 0xFF, 0x7F, 0x3F, // 53 5
    0xFC, 0xFE, 0xFF, 0x8F, 0x87, 0x87, 0x8F, 0x8F, 0x1E, 0x1C, 0x3F, 0x7F, 0xFF, 0xF3, 0xE3, 0xE3, 0xF7, 0xFF, 0x7F, 0x3E, // 54 6
    0x07, 0x07, 0x07, 0x07, 0x07, 0xC7, 0xF7, 0xFF, 0x3F, 0x0F, 0x00, 0x00, 0xF0, 0xFC, 0xFF, 0x0F, 0x03, 0x00, 0x00, 0x00, // 55 7
    0x7C, 0xFE, 0xFF, 0xCF, 0x87, 0x87, 0xCF, 0xFF, 0xFE, 0x7C, 0x3E, 0x7F, 0xFF, 0xF7, 0xE3, 0xE3, 0xF7, 0xFF, 0x7F, 0x3E, // 56 8
    0xFC, 0xFE, 0xFF, 0xCF, 0x87, 0x87, 0x8F, 0xFF, 0xFE, 0xFC, 0x30, 0x71, 0xF3, 0xE3, 0xE3, 0xE3, 0xF3, 0xFF, 0x7F, 0x3F, // 57 9
    0x70, 0x70, 0x70, 0x0E, 0x0E, 0x0E, // 58 :
    0x00, 0x00, 0x70, 0x70, 0x70, 0x20, 0x10, 0x1E, 0x0E, 0x0E, // 59 ;
    0x80, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0C, 0x04, 0x03, 0x07, 0x0E, 0x1C, 0x38, 0x30, 0x20, 0x00, // 60 <
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, // 61 =
    0x04, 0x0C, 0x1C, 0x38, 0x70, 0xE0, 0xC0, 0x80, 0x20, 0x30, 0x38, 0x1C, 0x0E, 0x06, 0x03, 0x01, // 62 >
    0x0E, 0x0F, 0x87, 0xC3, 0xE7, 0xFF, 0x7F, 0x1E, 0x00, 0x00, 0xCF, 0xCF, 0xCF, 0x00, 0x00, 0x00, // 63 ?
    0xFC, 0xFE, 0x07, 0x03, 0xE3, 0xF3, 0x33, 0x37, 0xFE, 0xFC, 0x3F, 0x7F, 0xE0, 0xC0, 0xC7, 0xCF, 0xCC, 0xCC, 0xCF, 0x07, // 64 @
    0xF0, 0xF8, 0xFC, 0x1E, 0x0F, 0x0F, 0x1E, 0xFC, 0xF8, 0xF0, 0xFF, 0xFF, 0xFF, 0x1C, 0x1C, 0x1C, 0x1C, 0xFF, 0xFF, 0xFF, // 65 A
    0x07, 0xFF, 0xFF, 0xFF, 0xC7, 0xC7, 0xEF, 0xFF, 0xFE, 0x3C, 0xE0, 0xFF, 0xFF, 0xFF, 0xE1, 0xE1, 0xE3, 0xFF, 0x7F, 0x3E, // 66 B
    0xFC, 0xFE, 0xFF, 0x0F, 0x07, 0x07, 0x07, 0x0F, 0x0E, 0x0C, 0x3F, 0x7F, 0xFF, 0xF0, 0xE0, 0xE0, 0xE0, 0xF0, 0x70, 0x30, // 67 C
    0x07, 0xFF, 0xFF, 0xFF, 0x07, 0x07, 0x0F, 0xFF, 0xFE, 0xFC, 0xE0, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0, 0xF0, 0xFF, 0x7F, 0x3F, // 68 D
    0x07, 0xFF, 0xFF, 0xFF, 0x87, 0x87, 0x87, 0x87, 0x07, 0x07, 0xE0, 0xFF, 0xFF, 0xFF, 0xE3, 0xE3, 0xE3, 0xE3, 0xE0, 0xE0, // 69 E
    0xFF, 0xFF, 0xFF, 0x87, 0x87, 0x87, 0x87, 0x87, 0x07, 0x07, 0xFF, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, // 70 F
    0xFC, 0xFE, 0xFF, 0x0F, 0x07, 0x07, 0x0F, 0x0F, 0x0E, 0x0C, 0x3F, 0x7F, 0xFF, 0xF0, 0xE0, 0xE0, 0xE7, 0xF7, 0x7F, 0x3F, // 71 G
    0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03, 0xFF, 0xFF, 0xFF, // 72 H
    0x03, 0xFF, 0xFF, 0xFF, 0x03, 0xC0, 0xFF, 0xFF, 0xFF, 0xC0, // 73 I
    0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0xFF, 0xFF, 0xFF, 0x03, 0x38, 0x78, 0xF8, 0xF0, 0xE0, 0xF0, 0xFF, 0x7F, 0x3F, 0x00, // 74 J
    0xFF, 0xFF, 0xFF, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0xFF, 0xFF, 0xFF, 0x03, 0x07, 0x0E, 0x1C, 0x38, 0x70, 0xE0, // 75 K
    0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, // 76 L
    0xFF, 0xFF, 0xFF, 0x3C, 0x78, 0xF0, 0x78, 0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, // 77 M
    0xFF, 0xFF, 0xFF, 0x7C, 0xF0, 0x80, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0x0F, 0x3E, 0xFF, 0xFF, 0xFF, // 78 N
    0xFC, 0xFE, 0xFF, 0x0F, 0x07, 0x07, 0x0F, 0xFF, 0xFE, 0xFC, 0x3F, 0x7F, 0xFF, 0xF0, 0xE0, 0xE0, 0xF0, 0xFF, 0x7F, 0x3F, // 79 O
    0xFF, 0xFF, 0xFF, 0x87, 0x87, 0x87, 0xCF, 0xFF, 0xFE, 0xFC, 0xFF, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x00, // 80 P
    0xFC, 0xFE, 0xFF, 0x07, 0x07, 0x07, 0x07, 0xFF, 0xFE, 0xFC, 0x3F, 0x7F, 0xFF, 0xE0, 0xE0, 0xFC, 0x78, 0xFF, 0xFF, 0x9F, // 81 Q
    0xFF, 0xFF, 0xFF, 0x87, 0x87, 0x87, 0xCF, 0xFF, 0xFE, 0x7C, 0xFF, 0xFF, 0xFF, 0x07, 0x0F, 0x1F, 0x3F, 0x7B, 0xF0, 0xE0, // 82 R
    0x7C, 0xFE, 0xFF, 0xCF, 0x87, 0x87, 0x87, 0x8F, 0x0E, 0x0C, 0x30, 0x71, 0xF3, 0xE3, 0xE3, 0xE3, 0xF7, 0xFF, 0x7F, 0x3E, // 83 S
    0x07, 0x07, 0x07, 0xFF, 0xFF, 0xFF, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, // 84 T
    0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x3F, 0x7F, 0xFF, 0xF0, 0xE0, 0xE0, 0xF0, 0xFF, 0x7F, 0x3F, // 85 U
    0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x01, 0x0F, 0x3F, 0xFE, 0xF0, 0XF0, 0xFE, 0x3F, 0x0F, 0x01, // 86 V
    0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0x3C, 0x1E, 0x0F, 0x1E, 0x3C, 0x78, 0xFF, 0xFF, 0xFF, // 87 W
    0x07, 0x1F, 0x7F, 0x7C, 0xE0, 0x80, 0xE0, 0x7C, 0x7F, 0x1F, 0x07, 0xE0, 0xF8, 0xFE, 0x3E, 0x07, 0x01, 0x07, 0x3E, 0xFE, 0xF8, 0xE0, // 88 X
    0x3F, 0x7F, 0xFF, 0xE0, 0xC0, 0x80, 0xC0, 0xE0, 0xFF, 0x7F, 0x3F, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, // 89 Y
    0x07, 0x07, 0x07, 0x87, 0xC7, 0xE7, 0xF7, 0x7F, 0x3F, 0x1F, 0xFC, 0xFE, 0xFF, 0xE7, 0xE3, 0xE1, 0xE0, 0xE0, 0xE0, 0xE0, // 90 Z
    0xFF, 0xFF, 0xFF, 0x07, 0x07, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0, // 91 [
    0x03, 0x1F, 0xFF, 0xF8, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1F, 0xFF, 0xF8, 0xC0, // 92 "\"
    0x07, 0x07, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF, // 93 ]
    0x30, 0x38, 0x1C, 0x0E, 0x07, 0x0E, 0x1C, 0x38, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94 ^
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0  // 95 _
// characters greater than 95 (0x5F) are not defined in this limited character set.
};

#endif
/*
There is some debate on the use of the font size in the data structure.
 In some cases it is used as an offset to the next font structure (which means it does have the size).
 In other cases it holds the actual address of the next font structure.
 Its only use within the Arduino DMD library is to determine whether or not the font is fixed or variable width:
  - zero indicates a variable width font and each character width is defined in the 'width' array
  - non zero indicates a fixed width font and its value is the character width. No 'width' array is then present.

Each character is made up of a fixed 16 pixels height by a variable number of pixels in width.
Each vertical column is represented by 2 bytes - the top 8 rows of pixels and the bottom 8 rows.
The top 8 rows are specified first, from left to right, followed by the lower 8 rows from left to right.
A '1' indicates the pixel is ON, and a '0' represents OFF.
The character width determines the number of bytes required for a character.
2 bytes are required per pixel in width in this font.
Fonts of 8 or fewer pixels in height require only 1 byte per pixel in width.
If the font 'size' is specified as "0x00, 0x00," then the font is fixed width and all character definitions
 must have the same number of bytes in their definition, and the width is specified in the font_Width.
 No font character width table is required or allowed in this case. 
The character definition consists of the list of data bytes starting from the top left byte through to
 the top right byte, followed by the lower left byte through to the lower right byte.

The example below shows how the character '1' is represented in this font.
Bytes and bits are numbered from 0 (not 1)'
 
   ______________ byte 0 = 0C  this byte is specified first
  |  ____________ byte 1 = 0E  followed by this one
  | |  __________ byte 2 = FF
  | | |  ________ byte 3 = FF
  | | | |  ______ byte 4 = FF
  | | | | |  ____ byte 5 = 00
  | | | | | |  __ byte 6 = 00
  | | | | | | |
      * * *     - bit 0  a '0' in bytes 0, 1, a '1' in bytes 3, 4, 5, and a '0' in bytes 5 & 6.
    * * * *     - bit 1
  * * * * *     - bit 2
  * * * * *     - bit 3
      * * *     - bit 4
      * * *     - bit 5                 Character '1' has a width of 0x07
      * * *     - bit 6                 Character '1' is represented by "0x0C, 0x0E, 0xFF, 0xFF,
      * * *     - bit 7                   0xFF, 0x00, 0x00, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0"
      * * *     - bit 0
      * * *     - bit 1
      * * *     - bit 2
      * * *     - bit 3
      * * *     - bit 4
  * * * * * * * - bit 5
  * * * * * * * - bit 6
  * * * * * * * - bit 7
  ^ ^ ^ ^ ^ ^ ^
  | | | | | | |__ byte n   = E0  this byte is specified last
  | | | | | |____ byte n-1 = E0  this byte is specified 2nd last
  | | | | |______ byte n-2 = FF
  | | | |________ byte n-3 = FF
  | | |__________ byte n-4 = FF
  | |____________ byte n-5 = E0
  |______________ byte n-6 = E0  this byte is specified after all the upper bytes are specified

*/
